/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc;

import icyllis.modernui.graphics.textmc.TextLayoutProcessor;
import icyllis.modernui.graphics.textmc.pipeline.GlyphRender;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextPropertiesManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

@OnlyIn(value=Dist.CLIENT)
public class ModernStringSplitter
extends CharacterManager {
    private final TextLayoutProcessor mFontEngine = TextLayoutProcessor.getInstance();
    private final MutableFloat v = new MutableFloat();

    public ModernStringSplitter(CharacterManager.ICharWidthProvider vanillaWidths) {
        super(vanillaWidths);
    }

    public float func_238350_a_(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        return this.mFontEngine.lookupVanillaNode((CharSequence)text, (Style)Style.field_240709_b_).advance;
    }

    public float func_238356_a_(@Nonnull ITextProperties text) {
        this.v.setValue(0.0f);
        text.func_230439_a_((s2, t) -> {
            if (!t.isEmpty()) {
                if (s2.func_240729_k_() != Minecraft.field_71464_q) {
                    this.v.add(this.mFontEngine.lookupVanillaNode((CharSequence)t, (Style)s2).advance);
                } else {
                    this.v.setValue(-1.0f);
                    return ITextProperties.field_240650_b_;
                }
            }
            return Optional.empty();
        }, Style.field_240709_b_);
        return this.v.floatValue() >= 0.0f ? this.v.floatValue() : super.func_238356_a_(text);
    }

    public float func_243238_a(@Nonnull IReorderingProcessor text) {
        this.v.setValue(0.0f);
        this.mFontEngine.handleSequence(text, (t, s2) -> {
            if (t.length() != 0) {
                this.v.add(this.mFontEngine.lookupVanillaNode((CharSequence)t, (Style)s2).advance);
            }
            return false;
        });
        return this.v.floatValue();
    }

    public int func_238352_a_(@Nonnull String text, int width, @Nonnull Style style) {
        return this.sizeToWidth0(text, width, style);
    }

    private int sizeToWidth0(@Nonnull CharSequence text, float width, @Nonnull Style style) {
        int glyphIndex;
        if (text.length() == 0) {
            return 0;
        }
        GlyphRender[] glyphs = this.mFontEngine.lookupVanillaNode((CharSequence)text, (Style)style).glyphs;
        float advance = 0.0f;
        for (glyphIndex = 0; glyphIndex < glyphs.length && (advance += glyphs[glyphIndex].getAdvance()) <= width; ++glyphIndex) {
        }
        return glyphIndex < glyphs.length ? glyphs[glyphIndex].stringIndex : text.length();
    }

    @Nonnull
    public String func_238361_b_(@Nonnull String text, int width, @Nonnull Style style) {
        return text.substring(0, this.sizeToWidth0(text, width, style));
    }

    @Nonnull
    public String func_238364_c_(@Nonnull String text, int width, @Nonnull Style style) {
        int glyphIndex;
        if (text.isEmpty()) {
            return text;
        }
        GlyphRender[] glyphs = this.mFontEngine.lookupVanillaNode((CharSequence)text, (Style)style).glyphs;
        float advance = 0.0f;
        for (glyphIndex = glyphs.length - 1; glyphIndex >= 0 && (advance += glyphs[glyphIndex].getAdvance()) <= (float)width; --glyphIndex) {
        }
        int l = glyphIndex >= 0 ? glyphs[glyphIndex].stringIndex : 0;
        return text.substring(l);
    }

    @Nullable
    public Style func_238357_a_(@Nonnull ITextProperties text, int width) {
        this.v.setValue((float)width);
        return text.func_230439_a_((s2, t) -> {
            if (this.sizeToWidth0(t, this.v.floatValue(), s2) < t.length()) {
                return Optional.of(s2);
            }
            this.v.subtract(this.mFontEngine.lookupVanillaNode((CharSequence)t, (Style)s2).advance);
            return Optional.empty();
        }, Style.field_240709_b_).orElse(null);
    }

    @Nullable
    public Style func_243239_a(@Nonnull IReorderingProcessor text, int width) {
        this.v.setValue((float)width);
        MutableObject sr = new MutableObject();
        if (!this.mFontEngine.handleSequence(text, (t, s2) -> {
            if (this.sizeToWidth0(t, this.v.floatValue(), s2) < t.length()) {
                sr.setValue((Object)s2);
                return true;
            }
            this.v.subtract(this.mFontEngine.lookupVanillaNode((CharSequence)t, (Style)s2).advance);
            return false;
        })) {
            return (Style)sr.getValue();
        }
        return null;
    }

    @Nonnull
    public ITextProperties func_238358_a_(@Nonnull ITextProperties textIn, int width, @Nonnull Style styleIn) {
        TextPropertiesManager collector = new TextPropertiesManager();
        this.v.setValue((float)width);
        return textIn.func_230439_a_((style, text) -> {
            int size = this.sizeToWidth0(text, this.v.floatValue(), style);
            if (size < text.length()) {
                String sub = text.substring(0, size);
                if (!sub.isEmpty()) {
                    collector.func_238155_a_(ITextProperties.func_240653_a_((String)sub, (Style)style));
                }
                return Optional.of(collector.func_238156_b_());
            }
            if (!text.isEmpty()) {
                collector.func_238155_a_(ITextProperties.func_240653_a_((String)text, (Style)style));
            }
            this.v.subtract(this.mFontEngine.lookupVanillaNode((CharSequence)text, (Style)style).advance);
            return Optional.empty();
        }, styleIn).orElse(textIn);
    }

    public void func_238353_a_(String text, int wrapWidth, @Nonnull Style style, boolean retainEnd, @Nonnull CharacterManager.ISliceAcceptor consumer) {
        super.func_238353_a_(text, wrapWidth, style, retainEnd, consumer);
    }

    @Nonnull
    public List<ITextProperties> func_238365_g_(String text, int wrapWidth, @Nonnull Style style) {
        return super.func_238365_g_(text, wrapWidth, style);
    }
}

